@extends('user')
@section('content')
    @include('partials.breadcrumb')




    <div class="dedicated-plan">
        <div class="container">
            <div class="row">

                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">@lang('Referral Link')</h3>
                        </div>
                        <div class="card-body">
                            <div class="input-group mb-3">
                                <input type="text" id="myInput" class="form-control" value="{{ route('refer.register',auth::user()->username) }}">
                                <div class="input-group-prepend" style="cursor: pointer" >
                                    <span class="input-group-text copy" style="cursor: pointer" onclick="myFunction()"  id="copybtn">@lang('COPY URL')</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="col-md-12">
                    @include('errors.error')
                    <div class="plan-table mt-3">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">@lang('Date')</th>
                                <th scope="col">@lang('Bonus')</th>
                                <th scope="col">@lang('Remaining Balance')</th>
                                <th scope="col">@lang('Details') </th>
                            </tr>
                            </thead>

                            <tbody>
                            @if(count($trx) >0)
                                @foreach($trx as $k=>$data)
                                    <tr>
                                        <th data-label="Date"><i class="fas fa-calendar-alt"></i> {{ date('d M Y',strtotime($data->created_at))}}</th>
                                        <td data-label="Bonus">
                                            <i class="icofont-money"></i>
                                            <span class="strong">{{number_format($data->amount,$basic->decimal)}} </span>
                                            <span class="strong base-color">{{$basic->currency}}</span>
                                        </td>
                                        <td data-label="Remaining Balance">
                                            <i class="icofont-money"></i>
                                            <span class="strong">{{number_format($data->main_amo,$basic->decimal)}} </span>
                                            <span class="strong base-color">{{$basic->currency}}</span>
                                        </td>

                                        <td data-label="Details"> {{$data->title}}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="4"> @lang('No Data Found!')</td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>
                    {!! $trx->links() !!}
                </div>
            </div>
        </div>
    </div>







@endsection
@section('js')
    <script>
        function myFunction() {
            /* Get the text field */
            var copyText = document.getElementById("myInput");

            /* Select the text field */
            copyText.select();

            /* Copy the text inside the text field */
            document.execCommand("copy");

        }
    </script>
@endsection
